# change [PATH] accordingly to parent directory of files! 
setwd("[PATH]")

library(ggplot2)
library(dplyr)

rm(list=ls(all=TRUE))
load("UCDP One-sided Violence Dataset v 1.4-2014.rdata")

# retain only data since 1999 (first PoC resolution 1265)
ucdpOneSided <- filter(ucdpOneSided, Year >= 1999)

# aggregate by year and conflict (location)
agg.location <- aggregate(ucdpOneSided$BestFatalityEstimate, 
                          list(year=ucdpOneSided$Year, location=ucdpOneSided$Location), sum)

# calculate minimum and maximum per year
agg.location.max <- aggregate(agg.location$x, list(year=agg.location$year), max, na.rm=T)
agg.location.min <- aggregate(agg.location$x, list(year=agg.location$year), min, na.rm=T)

# create two data sets: (a) only conflicts with PoC resolution, (b) all other conflicts (used to calculate the mean line)
agg.poc <- agg.location[grep("Afghanistan|Burundi|Central African Republic|Chad|Ivory Coast|DR Congo|Haiti|Liberia|Libya|Mali|Sierra Leone|Somalia|Sudan|South Sudan|East Timor", 
                             agg.location$location),]
agg.poc <- agg.poc[grep(",", agg.poc$location, invert=T),] # only keep data with unique location

agg.nopoc <- agg.location[grep("Afghanistan|Burundi|Central African Republic|Chad|Ivory Coast|DR Congo|Haiti|Liberia|Libya|Mali|Sierra Leone|Somalia|Sudan|South Sudan|East Timor", 
                             agg.location$location, invert=T),]
agg.nopoc <- agg.nopoc[grep(",", agg.nopoc$location, invert=T),] # only keep data with unique location
agg.nopoc.mean <- aggregate(agg.nopoc$x, list(year=agg.nopoc$year), function(x) round(mean(x)))

# Plot the data
source("../Visualization_Theme.R") # central theme used for all figures 
ggplot() + 
  geom_ribbon(aes(ymin = agg.location.min$x, 
                  ymax = agg.location.max$x, linetype=NA), 
              x = agg.nopoc.mean$year, alpha=.2, fill="red") +
  geom_line(aes(x=year, y=x, colour=location), agg.poc, linetype="dashed", alpha=1) + 
  geom_point(aes(x=year, y=x, colour=location), agg.poc) +
  geom_line(aes(x=year, y=x, group=1), agg.nopoc.mean, linetype="solid", colour="red") +
  scale_color_discrete(name="Conflict") + xlab("") + ylab("Number of civilian deaths") +
  theme(axis.text  = element_text(size=12)) +
  theme_MA()
